
(* 2x1 flyways 1 xbots - ZoneFencing,DefineZone,ZoneGetStatus *)
FUNCTION_BLOCK Example32_zonefencing
	(*move xbot 1 to starting position*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := Execute,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*define zone 6 as the boundary between the two flyways*)
	PMC_Zone_DefineZone1(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,ZoneID := 6,BottomLeftX := 0.18,BottomLeftY := 0,TopRightX := 0.3,TopRightY := 0.24,EnableZLimit := 0,ZLimit := 0);

	(*turn on fence on zone 6*)
	PMC_Zone_Fencing1(PM_Controller := PM_Controller,Execute := PMC_Zone_DefineZone1.Done,ZoneID := 6,Level := 1);

	(*get status of zone 6*)
	PMC_Zone_GetStatus1(PM_Controller := PM_Controller,Execute := PMC_Zone_Fencing1.Done,ZoneID := 6);

	(*move xbot 1 to other side of flyways (will hit fence)*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_Zone_GetStatus1.Done,cmdLB := 2,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.42,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*wait for xbot to hit fence*)
	Delay1(Execute := PMC_XYMotion2.Ack,Cycles := 3000);

	(*turn off fence on zone 6 to let the xbot through*)
	PMC_Zone_Fencing2(PM_Controller := PM_Controller,Execute := Delay1.Done,ZoneID := 6,Level := 0);

	(*set speed override through zone 6 to 0.1 *)
	PMC_Zone_OverrideZone1(PM_Controller := PM_Controller,Execute := PMC_Zone_Fencing2.Done,ZoneID := 6,SpeedOverrideFactor := 0.1,AccOverrideFactor := 1);

	(*set speed override in zone 6 back to 1*)
	PMC_Zone_OverrideZone2(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Done,ZoneID := 6,SpeedOverrideFactor := 1,AccOverrideFactor := 1);
	
	(*Done is when the xbot reaches the other side*)
	Done := PMC_Zone_OverrideZone2.Done;	
END_FUNCTION_BLOCK
